unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Gradient, Menus;

type
  TMainForm = class(TForm)
    AnimTimer: TTimer;
    Toolbar: TPanel;
    GradientStyles: TComboBox;
    Label1: TLabel;
    Panel: TPanel;
    Gradient: TGradient;
    AnimShift: TCheckBox;
    AnimRotation: TCheckBox;
    Image: TImage;
    ShowImage: TCheckBox;
    Label2: TLabel;
    GradientShapes: TComboBox;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure GradientStylesChange(Sender: TObject);
    procedure ShowImageClick(Sender: TObject);
    procedure AnimShiftClick(Sender: TObject);
    procedure AnimRotationClick(Sender: TObject);
    procedure AnimTimerTimer(Sender: TObject);
    procedure GradientCustom(Sender: TObject;
      const Colors: TGradientColors; Pattern: TBitmap);
    procedure PanelResize(Sender: TObject);
    procedure GradientShapesChange(Sender: TObject);
  private
    ShiftStep: Integer;
    RotateStep: Integer;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

{$I DELPHIAREA.INC}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  { TGradient is a non-windowed control and uses its parent's canvas to draw }
  { itself. Because of that if another non-windowed control places over the  }
  { TGradient and we animate the gradient, we see flickring. To prevent this }
  { issue on Delphi 4 and higher, we can set DoubleBuffered property of the  }
  { parent control to True.                                                  }
  {
  { If you are not going to animate the gradient colors, you do not need to  }
  { turn on double buffering.                                                }

  {$IFDEF COMPILER4_UP}
  Panel.DoubleBuffered := True;
  {$ELSE}
  ShowImage.Enabled := False; { older versions do not supprt double buffering }
  {$ENDIF}

  GradientStyles.ItemIndex := Ord(Gradient.Style);
  GradientShapes.ItemIndex := Ord(Gradient.Shape);

  ShiftStep := 1;
  RotateStep := 1;
end;

procedure TMainForm.PanelResize(Sender: TObject);
begin
  Image.Left := Gradient.Left + (Gradient.Width - Image.Width) div 2;
  Image.Top := Gradient.Top + (Gradient.Height - Image.Height) div 2;
end;

procedure TMainForm.GradientStylesChange(Sender: TObject);
begin
  Gradient.Style := TGradientStyle(GradientStyles.ItemIndex);
end;

procedure TMainForm.GradientShapesChange(Sender: TObject);
begin
  Gradient.Shape := TShapeType(GradientShapes.ItemIndex);
end;

procedure TMainForm.ShowImageClick(Sender: TObject);
begin
  Image.Visible := ShowImage.Checked;
end;

procedure TMainForm.AnimShiftClick(Sender: TObject);
begin
  AnimTimer.Enabled := AnimShift.Checked or AnimRotation.Checked;
end;

procedure TMainForm.AnimRotationClick(Sender: TObject);
begin
  AnimTimer.Enabled := AnimShift.Checked or AnimRotation.Checked;
end;

procedure TMainForm.AnimTimerTimer(Sender: TObject);
begin
  with Gradient do
  begin
    BeginUpdate; { Do not update the screen }
    try
      if AnimShift.Checked then
      begin
        if Shift = Low(TGradientShift) then
          ShiftStep := +1
        else if Shift = High(TGradientShift) then
          ShiftStep := -1;
        Shift := Shift + ShiftStep;
      end;
      if AnimRotation.Checked then
      begin
        if Rotation = Low(TGradientRotation) then
          RotateStep := +1
        else if Rotation = High(TGradientRotation) then
          RotateStep := -1;
        Rotation := Rotation + RotateStep;
      end;
    finally
      EndUpdate; { Updates the screen, if it is necessary }
    end;
  end;
end;

procedure TMainForm.GradientCustom(Sender: TObject;
  const Colors: TGradientColors; Pattern: TBitmap);
var
  X, Y: Integer;
  Row: PRGBQuadArray;
begin
  Pattern.Width := 256;
  Pattern.Height := 256;
  for Y := 0 to 255 do
  begin
    Row := PRGBQuadArray(Pattern.ScanLine[Y]);
    for X := 0 to 255 do
      Row[X] := Colors[Random(256)];
  end;
end;

end.
