unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtDlgs, ToolWin, ImgList, SysImg, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    SysImageList: TSysImageList;
    ListView: TListView;
    SaveDialog: TSaveDialog;
    Panel1: TPanel;
    IconSet: TRadioGroup;
    IconSize: TRadioGroup;
    btnExport: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ListViewData(Sender: TObject; Item: TListItem);
    procedure ListViewDataHint(Sender: TObject; StartIndex, EndIndex: Integer);
    procedure ListViewSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
    procedure IconSetClick(Sender: TObject);
    procedure IconSizeClick(Sender: TObject);
    procedure btnExportClick(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  ListView.Items.Count := SysImageList.Count;
end;

procedure TMainForm.ListViewData(Sender: TObject; Item: TListItem);
begin
  with Item do
  begin
    Caption := IntToStr(Index);
    ImageIndex := Index;
  end;
end;

procedure TMainForm.ListViewDataHint(Sender: TObject; StartIndex, EndIndex: Integer);
var
  Index: Integer;
begin
  for Index := StartIndex to EndIndex do
    with ListView.Items[Index] do
    begin
      Caption := IntToStr(Index);
      ImageIndex := Index;
    end;
end;

procedure TMainForm.ListViewSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  btnExport.Enabled := (ListView.SelCount > 0);
end;

procedure TMainForm.IconSetClick(Sender: TObject);
begin
  SysImageList.IconSet := TIconSet(IconSet.ItemIndex);
  ListView.Items.Count := SysImageList.Count;
  btnExport.Enabled := (ListView.SelCount > 0);
end;

procedure TMainForm.IconSizeClick(Sender: TObject);
begin
  SysImageList.IconSize := TIconSize(IconSize.ItemIndex);
end;

procedure TMainForm.btnExportClick(Sender: TObject);
var
  Bitmap: TBitmap;
  X, Index: Integer;
begin
  if SaveDialog.Execute then
  begin
    Bitmap := TBitmap.Create;
    try
      Bitmap.Height := SysImageList.Height;
      Bitmap.Width := SysImageList.Width * ListView.SelCount;
      Bitmap.Canvas.Brush.Color := clFuchsia;
      Bitmap.Canvas.FillRect(Bitmap.Canvas.ClipRect);
      X := 0;
      for Index := ListView.Selected.Index to ListView.Items.Count - 1 do
        if ListView.Items[Index].Selected then
        begin
          SysImageList.Draw(Bitmap.Canvas, X, 0, Index);
          Inc(X, SysImageList.Width);
          if X >= Bitmap.Width then Break;
        end;
      Bitmap.SaveToFile(SaveDialog.FileName);
    finally
      Bitmap.Free;
    end;
  end;
end;

end.
