unit Main;

{$I DELPHIAREA.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, AniImg {$IFDEF COMPILER4_UP}, ImgList {$ENDIF};

type
  TForm1 = class(TForm)
    ImageList1: TImageList;
    AnimateImage1: TAnimateImage;
    Bevel1: TBevel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label1: TLabel;
    Edit1: TEdit;
    UpDown1: TUpDown;
    Label2: TLabel;
    Edit2: TEdit;
    UpDown2: TUpDown;
    procedure CheckBox1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure AnimateImage1Frame(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  AnimateImage1.Active := CheckBox1.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  AnimateImage1.Reverse := CheckBox2.Checked;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  AnimateImage1.FrameIndex := UpDown1.Position;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
  AnimateImage1.Interval := UpDown2.Position;
end;

procedure TForm1.AnimateImage1Frame(Sender: TObject);
begin
  UpDown1.Position := AnimateImage1.FrameIndex;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  CheckBox1.Checked := AnimateImage1.Active;
  CheckBox2.Checked := AnimateImage1.Reverse;
  UpDown1.Max := AnimateImage1.Images.Count - 1;
  UpDown1.Position := AnimateImage1.FrameIndex;
  UpDown2.Position := AnimateImage1.Interval;
end;


end.
