<?php
/*
Plugin Name: WP-Recent-phpBB
Plugin URI: http://www.delphiarea.com/products/wordpress-plugins/wp-recent-phpbb/
Description: Defines a fully customizable sidebar widget and shortcode to show the most recent phpBB posts.
Version: 1.3.2
Author: Kambiz R. Khojasteh
Author URI: kambiz@delphiarea.com
Tags: widget, phpbb, phpbb2, phpbb3
*/

add_action('plugins_loaded', 'phpbb_recent_posts_init');

function phpbb_recent_posts($args) {
  extract($args, EXTR_SKIP);
  
  $template_vars = array(
    '{POST_URL}', 
    '{POST_EXCERPT}', 
    '{POST_DATE}', 
    '{POST_TIME}', 
    '{POST_SINCE}', 
    '{TOPIC_URL}',  
    '{TOPIC_TITLE}', 
    '{FORUM_URL}',  
    '{FORUM_TITLE}', 
    '{USER_URL}', 
    '{USER_NAME}');
  
  $date_format = get_option('date_format');
  $time_format = get_option('time_format');
  $gmt_offset = get_option('gmt_offset') * 3600;
  
  $where = 'p.post_approved <> 0';
  if (!empty($user_include)) {
    if ($where != '')
      $where .= ' AND ';
    $where .= "LCASE(u.username) IN ($user_include)";
  }
  if (!empty($user_exclude)) {
    if ($where != '')
      $where .= ' AND ';
    $where .= "LCASE(u.username) NOT IN ($user_exclude)";
  }  
  if (!empty($forum_include)) {
    if ($where != '')
      $where .= ' AND ';
    $where .= "p.forum_id IN ($forum_include)";
  }
  if (!empty($forum_exclude)) {
    if ($where != '')
      $where .= ' AND ';
    $where .= "p.forum_id NOT IN ($forum_exclude)";
  }
  if (empty($template_new)) {
    if ($where != '')
      $where .= ' AND ';
    $where .= 'p.post_time <> t.topic_time';
  }
  if (empty($template_reply)) {
    if ($where != '')
      $where .= ' AND ';
    $where .= 'p.post_time = t.topic_time';
  }
  if ($where != '')
    $where = 'WHERE ' . $where;
  
  $query = "SELECT p.post_id, p.topic_id, p.forum_id, p.poster_id, p.post_time, p.post_text, u.username, t.topic_title, f.forum_name, (p.post_time = t.topic_time) AS is_new_topic, p.poster_ip FROM `${table_prefix}posts` AS p LEFT JOIN `${table_prefix}users` AS u ON p.poster_id = u.user_id LEFT JOIN `${table_prefix}topics` AS t ON p.topic_id = t.topic_id LEFT JOIN `${table_prefix}forums` AS f ON p.forum_id = f.forum_id $where ORDER BY post_id DESC LIMIT 0, $limit";
  if (!empty($db_host) || !empty($db_name)) {
    $phpbb = new wpdb(
      empty($db_user) ? DB_USER : $db_user, 
      empty($db_pass) ? DB_PASSWORD : $db_pass, 
      empty($db_name) ? DB_NAME : $db_name, 
      empty($db_host) ? DB_HOST : $db_host);
    $phpbb_posts = $phpbb->get_results($query);
    unset($phpbb);
  }
  else {
    global $wpdb;
    $phpbb_posts = $wpdb->get_results($query);
  }
  
  $is_text_needed = (strpos($template_new, $template_vars[0]) !== false) || (strpos($template_reply, $template_vars[0]) !== false);
  
  $result = "<ul class=\"phpbb\">\n";
  foreach((array) $phpbb_posts as $phpbb_post) {
    $phpbb3 = (strpos($phpbb_post->poster_ip, '.') !== false);
    $template_values = array(
      $link.'viewtopic.php?p='.$phpbb_post->post_id.($phpbb3 ? '#p' : '#').$phpbb_post->post_id,
      $is_text_needed ? phpbb_recent_posts_excerpt(preg_replace('/(\[)(.*)(\])/', '', $phpbb_post->post_text)) : '',
      date_i18n($date_format, $phpbb_post->post_time + $gmt_offset),
      date_i18n($time_format, $phpbb_post->post_time + $gmt_offset),
      phpbb_recent_posts_human_time($phpbb_post->post_time),
      $link.'viewtopic.php?t='.$phpbb_post->topic_id,
      $phpbb_post->topic_title,
      $link.'viewforum.php?f='.$phpbb_post->forum_id,
      $phpbb_post->forum_name,
      $link.($phpbb3 ? 'memberlist' : 'profile').'.php?mode=viewprofile&u='.$phpbb_post->poster_id,
      $phpbb_post->username);
    $template = $phpbb_post->is_new_topic ? $template_new : $template_reply;
    $result .= "<li>" . str_replace($template_vars, $template_values, $template) . "</li>\n";
  }
  $result .= "</ul>\n";
  if ($show_link)
    $result .= "<a class=\"phpbb\" href=\"$link\">$link_title</a>\n";
  return $result;
}

function phpbb_recent_posts_defaults($options = null) {
  $defaults = array (
    'title'           => __('Recent Forum Posts', 'wp-recent-phpbb'),
    'db_host'         => '',
    'db_name'         => '',
    'db_user'         => '',
    'db_pass'         => '',
    'table_prefix'    => 'phpbb_',
    'link'            => '',
    'limit'           => 5,
    'template_new'    => __('New topic <a href="{POST_URL}">{TOPIC_TITLE}</a> by <a href="{USER_URL}">{USER_NAME}</a> on {POST_DATE} at {POST_TIME} in <a href="{FORUM_URL}">{FORUM_TITLE}</a>', 'wp-recent-phpbb'),
    'template_reply'  => __('Reply on <a href="{POST_URL}">{TOPIC_TITLE}</a><span>{POST_EXCERPT}</span> by <a href="{USER_URL}">{USER_NAME}</a> on {POST_DATE} at {POST_TIME} in <a href="{FORUM_URL}">{FORUM_TITLE}</a>', 'wp-recent-phpbb'),
    'forum_include'   => '',
    'forum_exclude'   => '',
    'user_include'    => '',
    'user_exclude'    => '',
    'show_link'       => 1,
    'link_title'      => __('More &raquo;', 'wp-recent-phpbb'),
    'off_pages'       => array()
  );
  return array_merge($defaults, (array) $options);
}

function phpbb_recent_posts_excerpt($text, $max_words = 20) {
  $words = preg_split('/[\s]+/', strip_tags($text), -1, PREG_SPLIT_NO_EMPTY);
  $ellipsis = '&hellip;';
  if (count($words) > $max_words)
    $words = array_slice($words, 0, $max_words);
  else
    $ellipsis = '';
  return htmlentities(implode(' ', $words), ENT_QUOTES, get_bloginfo('charset')) . $ellipsis;
}

function phpbb_recent_posts_human_time($from, $to = '') {
  if (empty($to))
    $to = time();
  $diff = (int) abs($to - $from);
  if ($diff < 3600) {
    $mins = round($diff / 60);
    if ($mins < 1)
      $mins = 1;
    $since = sprintf(__ngettext('%s min', '%s mins', $mins, 'wp-recent-phpbb'), number_format_i18n($mins, 0));
  } 
  elseif ($diff < 86400) {
    $hours = round($diff / 3600);
    if ($hours < 1)
      $hours = 1;
    $since = sprintf(__ngettext('%s hour', '%s hours', $hours, 'wp-recent-phpbb'), number_format_i18n($hours, 0));
  } 
  elseif ($diff < 604800) {
    $days = round($diff / 86400);
    if ($days < 1)
      $days = 1;
    $since = sprintf(__ngettext('%s day', '%s days', $days, 'wp-recent-phpbb'), number_format_i18n($days, 0));
  } 
  else {
    $weeks = round($diff / 604800);
    if ($weeks < 1)
      $weeks = 1;
    $since = sprintf(__ngettext('%s week', '%s weeks', $weeks, 'wp-recent-phpbb'), number_format_i18n($weeks, 0));
  }
  return $since;
}

function php_recent_posts_quoted_list($items) {
  $list = array();
  foreach(explode(',', $items) as $item) {
    $item = strtolower(trim($item));
    if ($item != '' && !in_array($item, $list))
      $list[] = $item;
  };
  foreach ($list as $item)
    $quoted_list[] = "'$item'";
  return implode(', ', $quoted_list);
}

function phpbb_recent_posts_init() {
  load_plugin_textdomain('wp-recent-phpbb', false, 'wp-recent-phpbb');
  if (function_exists('register_sidebar_widget')) {
    $options = get_option('widget_phpbb_recent_posts');
    if (!is_array($options))
      $options = array();
    $widget_ops = array('classname' => 'widget_phpbb', 'description' => __('The most recent posts on your phpBB forums', 'wp-recent-phpbb'));
    $control_ops = array('id_base' => 'phpbb');
    $name = __('phpBB Recent Posts', 'wp-recent-phpbb');
    $id = '';
    foreach (array_keys($options) as $o) {
      if (!isset($options[$o]['title']))
        continue;
      $id = "phpbb-$o";
      wp_register_sidebar_widget($id, $name, 'widget_phpbb_recent_posts', $widget_ops, array('number' => $o));
      wp_register_widget_control($id, $name, 'widget_phpbb_recent_posts_control', $control_ops, array('number' => $o));
    }
    if (empty($id)) {
      wp_register_sidebar_widget('phpbb-1', $name, 'widget_phpbb_recent_posts', $widget_ops, array('number' => 1));
      wp_register_widget_control('phpbb-1', $name, 'widget_phpbb_recent_posts_control', $control_ops, array('number' => 1));
    }
  }
  if (function_exists('add_shortcode')) {
    add_shortcode('phpbb', 'shortcode_phpbb_recent_posts');
  }
}

function widget_phpbb_recent_posts($args, $widget_args = 1) {
  extract($args, EXTR_SKIP);
  if (is_numeric($widget_args))
    $widget_args = array('number' => $widget_args);
  $widget_args = wp_parse_args($widget_args, array('number' => -1));
  extract($widget_args, EXTR_SKIP);
    
  $options = get_option('widget_phpbb_recent_posts');
  if (!isset($options[$number]))
    return;
  $options[$number] = phpbb_recent_posts_defaults($options[$number]);

  if (is_front_page()) {
    $target = 'front';
    if (is_home())
      $target .= '|home';
  }
  elseif (is_page())
    $target = 'page';
  elseif (is_single())
    $target = 'post';
  elseif (is_archive()) {
    $target = 'archive';
    if (is_tag())
      $target .= '|tag';
    elseif (is_category())
      $target .= '|category';
  }
  elseif (is_search())
    $target = 'search';
  elseif (is_author())
    $target = 'author';
  else
    $target = 'other';
  if (in_array($target, (array) $options[$number]['off_pages']))
    return;
  
  $title = apply_filters('widget_title', $options[$number]['title']);
  
  echo $before_widget;
  if (!empty($title))
    echo $before_title . $title . $after_title;
  echo phpbb_recent_posts($options[$number]);
  echo $after_widget;
}
  
function widget_phpbb_recent_posts_control($widget_args) {
  global $wp_registered_widgets;
  static $updated = false;
    
  if (is_numeric($widget_args))
    $widget_args = array('number' => $widget_args);
  $widget_args = wp_parse_args($widget_args, array('number' => -1));
  extract($widget_args, EXTR_SKIP);
  $options = get_option('widget_phpbb_recent_posts');
  if (!is_array($options))
    $options = array();
        
  if (!$updated && !empty($_POST['sidebar'])) {
    $sidebar = (string) $_POST['sidebar'];
    $sidebars_widgets = wp_get_sidebars_widgets();
    if (isset($sidebars_widgets[$sidebar]))
      $this_sidebar =& $sidebars_widgets[$sidebar];
    else
      $this_sidebar = array();
    foreach ($this_sidebar as $_widget_id) {
      if ('widget_phpbb_recent_posts' == $wp_registered_widgets[$_widget_id]['callback'] && isset($wp_registered_widgets[$_widget_id]['params'][0]['number'])) {
        $widget_number = $wp_registered_widgets[$_widget_id]['params'][0]['number'];
        if (!in_array("phpbb-$widget_number", $_POST['widget-id'])) // the widget has been removed.
          unset($options[$widget_number]);
      }
    }
    foreach ((array) $_POST['widget_phpbb'] as $widget_number => $widget_phpbb) {
      if (!isset($widget_phpbb['title']) && isset($options[$widget_number])) // user clicked cancel
        continue;
      $options[$widget_number]['title'] = strip_tags(stripslashes($widget_phpbb['title']));
      $options[$widget_number]['db_host'] = stripslashes($widget_phpbb['db-host']);
      $options[$widget_number]['db_name'] = stripslashes($widget_phpbb['db-name']);
      $options[$widget_number]['db_user'] = stripslashes($widget_phpbb['db-user']);
      $options[$widget_number]['db_pass'] = stripslashes($widget_phpbb['db-pass']);
      $options[$widget_number]['table_prefix'] = strip_tags(stripslashes($widget_phpbb['table-prefix']));
      $options[$widget_number]['link'] = trailingslashit(strip_tags(stripslashes($widget_phpbb['link'])));
      $options[$widget_number]['limit'] = intval($widget_phpbb['limit']);
      $options[$widget_number]['template_new'] = stripslashes($widget_phpbb['template-new']);
      $options[$widget_number]['template_reply'] = stripslashes($widget_phpbb['template-reply']);
      $options[$widget_number]['forum_include'] = implode(', ', array_diff(array_unique(array_map('intval', explode(',', stripslashes($widget_phpbb['forum-include'])))), array(0)));
      $options[$widget_number]['forum_exclude'] = implode(', ', array_diff(array_unique(array_map('intval', explode(',', stripslashes($widget_phpbb['forum-exclude'])))), array(0)));
      $options[$widget_number]['user_include'] = php_recent_posts_quoted_list(stripslashes($widget_phpbb['user-include']));
      $options[$widget_number]['user_exclude'] = php_recent_posts_quoted_list(stripslashes($widget_phpbb['user-exclude']));
      $options[$widget_number]['show_link'] = intval($widget_phpbb['show-link']);
      $options[$widget_number]['link_title'] = stripslashes($widget_phpbb['link-title']);
      $options[$widget_number]['off_pages'] = stripslashes_deep(array_values((array) $widget_phpbb['off-pages']));
    }
    update_option('widget_phpbb_recent_posts', $options);
    $updated = true;
  }

  if (-1 == $number) {
    $number = '%i%';
    $this_options = array();
  }
  else
    $this_options = $options[$number];
  $this_options = phpbb_recent_posts_defaults($this_options);
        
  $title = attribute_escape($this_options['title']);
  $db_host = attribute_escape($this_options['db_host']);
  $db_name = attribute_escape($this_options['db_name']);
  $db_user = attribute_escape($this_options['db_user']);
  $db_pass = attribute_escape($this_options['db_pass']);
  $table_prefix = attribute_escape($this_options['table_prefix']);
  $link = attribute_escape($this_options['link']);
  $limit = intval($this_options['limit']);
  $template_new =  htmlentities($this_options['template_new'], ENT_QUOTES, get_bloginfo('charset'));
  $template_reply = htmlentities($this_options['template_reply'], ENT_QUOTES, get_bloginfo('charset'));
  $forum_include = attribute_escape($this_options['forum_include']);
  $forum_exclude = attribute_escape($this_options['forum_exclude']);
  $user_include = attribute_escape(str_replace("'", '', $this_options['user_include']));
  $user_exclude = attribute_escape(str_replace("'", '', $this_options['user_exclude']));
  $show_link = intval($this_options['show_link']);
  $link_title = htmlentities($this_options['link_title'], ENT_QUOTES, get_bloginfo('charset'));
  $off_pages = (array) $this_options['off_pages'];

?>
  <input type="hidden" id="widget_phpbb[<?php echo $number; ?>][submit]" name="widget_phpbb[<?php echo $number; ?>][submit]" value="1" />
  <p><label for="widget_phpbb[<?php echo $number; ?>][title]"><?php _e('Title:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][title]" name="widget_phpbb[<?php echo $number; ?>][title]" type="text" value="<?php echo $title; ?>" /></label></p>
  <hr />
  <p><?php _e('Leave the following fields blank if your phpBB and WordPress share same database.', 'wp-recent-phpbb'); ?></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][db-host]"><?php _e('DB Host:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][db-host]" name="widget_phpbb[<?php echo $number; ?>][db-host]" type="text" value="<?php echo $db_host; ?>" dir="ltr" /></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][db-name]"><?php _e('DB Name:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][db-name]" name="widget_phpbb[<?php echo $number; ?>][db-name]" type="text" value="<?php echo $db_name; ?>" dir="ltr" /></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][db-user]"><?php _e('DB User:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][db-user]" name="widget_phpbb[<?php echo $number; ?>][db-user]" type="text" value="<?php echo $db_user; ?>" dir="ltr" /></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][db-pass]"><?php _e('DB Password:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][db-pass]" name="widget_phpbb[<?php echo $number; ?>][db-pass]" type="password" value="<?php echo $db_pass; ?>" dir="ltr" /></label></p>
  <hr />
  <p><label for="widget_phpbb[<?php echo $number; ?>][table-prefix]"><?php _e('Table Prefix:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][table-prefix]" name="widget_phpbb[<?php echo $number; ?>][table-prefix]" type="text" value="<?php echo $table_prefix; ?>" dir="ltr" /></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][link]"><?php _e('phpBB URL:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][link]" name="widget_phpbb[<?php echo $number; ?>][link]" type="text" value="<?php echo $link; ?>" dir="ltr" /></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][limit]"><?php _e('Number of posts to show:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][limit]" name="widget_phpbb[<?php echo $number; ?>][limit]" type="text" value="<?php echo $limit; ?>" /></label></p>
  <hr />
  <p><label for="widget_phpbb[<?php echo $number; ?>][template-new]"><?php _e('Template for new topic:', 'wp-recent-phpbb'); ?> <textarea class="widefat" id="widget_phpbb[<?php echo $number; ?>][template-new]" name="widget_phpbb[<?php echo $number; ?>][template-new]" rows="10"><?php echo $template_new; ?></textarea><br /><small><?php _e('HTML is allowed.', 'wp-recent-phpbb'); ?> <?php _e('Leave this template blank if you don\'t want to include new topic posts.', 'wp-recent-phpbb'); ?></small></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][template-reply]"><?php _e('Template for reply:', 'wp-recent-phpbb'); ?> <textarea class="widefat" id="widget_phpbb[<?php echo $number; ?>][template-reply]" name="widget_phpbb[<?php echo $number; ?>][template-reply]" rows="10"><?php echo $template_reply; ?></textarea><br /><small><?php _e('HTML is allowed.', 'wp-recent-phpbb'); ?> <?php _e('Leave this template blank if you don\'t want to include reply posts.', 'wp-recent-phpbb'); ?></small></label></p>
  <p><?php _e('Template vriables:', 'wp-recent-phpbb'); ?><br>
    <small>
    <code style="font-size: larger; font-wieght: bolder;">{POST_URL}</code> - <?php _e('URL of post', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{POST_EXCERPT}</code> - <?php _e('Excerpt of the post', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{POST_DATE}</code> - <?php _e('Date of post', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{POST_TIME}</code> - <?php _e('Time of post', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{POST_SINCE}</code> - <?php _e('Time since publishing', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{TOPIC_URL}</code> - <?php _e('URL of post\'s topic', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{TOPIC_TITLE}</code> - <?php _e('Title of post\'s topic', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{FORUM_URL}</code> - <?php _e('URL of post\'s forum', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{FORUM_TITLE}</code> - <?php _e('Title of post\'s forum', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{USER_URL}</code> - <?php _e('URL of poster\'s profile', 'wp-recent-phpbb'); ?><br />
    <code style="font-size: larger; font-wieght: bolder;">{USER_NAME}</code> - <?php _e('Poster\'s user name', 'wp-recent-phpbb'); ?><br />
    </small>
  </p>
  <hr />
  <p><label for="widget_phpbb[<?php echo $number; ?>][forum-include]"><?php _e('Forums to include:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][forum-include]" name="widget_phpbb[<?php echo $number; ?>][forum-include]" type="text" value="<?php echo $forum_include; ?>" dir="ltr" /><br /><small><?php _e('Forum IDs, separated by commas. Leave blank to include all forums.', 'wp-recent-phpbb'); ?></small></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][forum-exclude]"><?php _e('Forums to exclude:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][forum-exclude]" name="widget_phpbb[<?php echo $number; ?>][forum-exclude]" type="text" value="<?php echo $forum_exclude; ?>" dir="ltr" /><br /><small><?php _e('Forum IDs, separated by commas.', 'wp-recent-phpbb'); ?></small></label></p>
  <hr />
  <p><label for="widget_phpbb[<?php echo $number; ?>][user-include]"><?php _e('Users to follow:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][user-include]" name="widget_phpbb[<?php echo $number; ?>][user-include]" type="text" value="<?php echo $user_include; ?>" dir="ltr" /><br /><small><?php _e('Usernames, separated by commas. Leave blank to follow all users.', 'wp-recent-phpbb'); ?></small></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][user-exclude]"><?php _e('Users to ignore:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][user-exclude]" name="widget_phpbb[<?php echo $number; ?>][user-exclude]" type="text" value="<?php echo $user_exclude; ?>" dir="ltr" /><br /><small><?php _e('Usernames, separated by commas.', 'wp-recent-phpbb'); ?></small></label></p>
  <hr />
  <p><label for="widget_phpbb[<?php echo $number; ?>][show-link]"><input id="widget_phpbb[<?php echo $number; ?>][show-link]" name="widget_phpbb[<?php echo $number; ?>][show-link]" type="checkbox" value="1" <?php echo $show_link ? 'checked="checked"' : ''; ?> /> <?php _e('Show link to phpBB', 'wp-recent-phpbb'); ?></label></p>
  <p><label for="widget_phpbb[<?php echo $number; ?>][link-title]"><?php _e('Title of link to phpBB:', 'wp-recent-phpbb'); ?> <input class="widefat" id="widget_phpbb[<?php echo $number; ?>][link-title]" name="widget_phpbb[<?php echo $number; ?>][link-title]" type="text" value="<?php echo $link_title; ?>" /><br /><small><?php _e('HTML is allowed.', 'wp-recent-phpbb'); ?></small></label></p>
  <hr />
  <p><?php _e('Do not show this widget on:', 'wp-recent-phpbb'); ?>
    <blockquote>
      <label for="widget_phpbb[<?php echo $number; ?>][off-pages][0]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][0]" name="widget_phpbb[<?php echo $number; ?>][off-pages][0]" type="checkbox" value="front" <?php echo in_array('front', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Front Page', 'wp-recent-phpbb'); ?></label><br />
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<label for="widget_phpbb[<?php echo $number; ?>][off-pages][1]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][1]" name="widget_phpbb[<?php echo $number; ?>][off-pages][1]" type="checkbox" value="front|home" <?php echo in_array('front|home', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Home', 'wp-recent-phpbb'); ?></label><br />
      <label for="widget_phpbb[<?php echo $number; ?>][off-pages][2]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][2]" name="widget_phpbb[<?php echo $number; ?>][off-pages][2]" type="checkbox" value="page" <?php echo in_array('page', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Static Pages', 'wp-recent-phpbb'); ?></label><br />
      <label for="widget_phpbb[<?php echo $number; ?>][off-pages][3]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][3]" name="widget_phpbb[<?php echo $number; ?>][off-pages][3]" type="checkbox" value="post" <?php echo in_array('post', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Single Posts', 'wp-recent-phpbb'); ?></label><br />
      <label for="widget_phpbb[<?php echo $number; ?>][off-pages][4]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][4]" name="widget_phpbb[<?php echo $number; ?>][off-pages][4]" type="checkbox" value="archive" <?php echo in_array('archive', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Archives', 'wp-recent-phpbb'); ?></label><br />
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<label for="widget_phpbb[<?php echo $number; ?>][off-pages][5]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][5]" name="widget_phpbb[<?php echo $number; ?>][off-pages][5]" type="checkbox" value="arcgive|tag" <?php echo in_array('archive|tag', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Tags', 'wp-recent-phpbb'); ?></label><br />
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<label for="widget_phpbb[<?php echo $number; ?>][off-pages][6]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][6]" name="widget_phpbb[<?php echo $number; ?>][off-pages][6]" type="checkbox" value="archive|category" <?php echo in_array('archive|category', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Category', 'wp-recent-phpbb'); ?></label><br />
      <label for="widget_phpbb[<?php echo $number; ?>][off-pages][7]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][7]" name="widget_phpbb[<?php echo $number; ?>][off-pages][7]" type="checkbox" value="search" <?php echo in_array('search', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Search Pages', 'wp-recent-phpbb'); ?></label><br />
      <label for="widget_phpbb[<?php echo $number; ?>][off-pages][8]"><input id="widget_phpbb[<?php echo $number; ?>][off-pages][8]" name="widget_phpbb[<?php echo $number; ?>][off-pages][8]" type="checkbox" value="author" <?php echo in_array('author', $off_pages) ? 'checked="checked"' : ''; ?> /> <?php _e('Author Pages', 'wp-recent-phpbb'); ?></label><br />
    </blockquote>
  </p>
<?php
}

function shortcode_phpbb_recent_posts($atts) {
  $atts = shortcode_atts(phpbb_recent_posts_defaults(), $atts);
  echo "<div class=\"phpbb\">\n";
  echo phpbb_recent_posts($atts);
  echo "</div>\n";
}

?>